// Camera.h: Schnittstelle fr die Klasse CCamera.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CAMERA_H__265E3981_AFBF_11D3_8F4A_706973C10500__INCLUDED_)
#define AFX_CAMERA_H__265E3981_AFBF_11D3_8F4A_706973C10500__INCLUDED_

#include "Landscape.h"	// Hinzugefgt von der Klassenansicht
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// math stuff
#include <math.h>

class CCamera  
{
public:
	void Move(bool bForward, bool bBackward, bool bStrafeLeft, bool bStrafeRight);
	void RotateVertical(float fDegrees);
	void RotateHorizontal(float fDegrees);
	void CenterVertical();
	void TransformWorld();
	CCamera();
	virtual ~CCamera();

	GLfloat	m_UpDown;		// Look up/down
	GLfloat	m_YRotate;		// Y rotation
	// Camera position
	GLfloat m_XPos;
	GLfloat m_YPos;
	GLfloat m_ZPos;
	// Walkbias
	GLfloat m_WalkBiasAngle;
	GLfloat m_WalkBias ;
	// Size of viewer
	GLfloat m_SizeOfViewer;
	// Movement speed
	GLfloat m_Speed;

	// Landscape class
	CLandscape m_Landscape;
private:
	bool CheckCollision(float fPointAfter[]);
};

#endif // !defined(AFX_CAMERA_H__265E3981_AFBF_11D3_8F4A_706973C10500__INCLUDED_)
